// Native routine to add command environments
#include <oorexxapi.h>
/* only used during development
#include <iostream>
using std::cout;    //*/

const int NUM_COMENVIRS = 5;    // five command environments

// Prototype for the command handler to be added to the interpreter instance
RexxObjectPtr RexxEntry theCommandHandler(RexxExitContext *context,
                                          RexxStringObject address,
                                          RexxStringObject command);    //*/

// -----------------------------------------------------
RexxRoutine0(RexxObjectPtr,             // return type is a Rexx Object Pointer
             add_envs)                  // native routine name
                                        // context is implicitly passed
{
    CSTRING envnames[] = {"TEST", "NONE", "OFF", "RESULT", "ECHO"};
    for (int ix = 0;ix < NUM_COMENVIRS; ix++) {
        context->AddCommandEnvironment(envnames[ix],
                                       (REXXPFN)theCommandHandler,
                                       DIRECT_COMMAND_ENVIRONMENT);
    }
    return NULLOBJECT;                  // indicate no return value!
}

RexxObjectPtr RexxEntry theCommandHandler(RexxExitContext *eContext,
                                          RexxStringObject address,
                                          RexxStringObject command)
{
    RexxDirectoryObject lcl;    // will hold pointer to .local
    RexxObjectPtr outp;         // will hold pointer to .output

    lcl = eContext->GetLocalEnvironment();
    outp = eContext->DirectoryAt(lcl, "OUTPUT");

    switch (eContext->CString(address)[0]) { // first char of subcommand name
    case 'N':   // NONE - ignore the input arguments (command)
    case 'O':   // OFF - same as NONE
        break;
    case 'R':   // RESULT - set the Rexx variable RESULT to the arg. string
        eContext->SetContextVariable("result", command);
        break;
    case 'E':   // ECHO - send the arg. string to .OUTPUT
        eContext->SendMessage1(outp, "say", command);
        break;
    default:    // must be TEST
    /*
        cout << "Name used to call this handler: "
             << eContext->CString(address);
        cout << "\nArgument(s) passed to this handler: ["
             << eContext->CString(command) << "]\n";    //*/
        RexxStringObject lit1, lit2;
        lit1 = eContext->CString("Name used to call this handler: ");
        eContext->SendMessage1(outp, "charout", lit1);
        eContext->SendMessage1(outp, "say", address);
        lit2 = eContext->CString("Argument(s) passed to this handler: [");
        eContext->SendMessage1(outp, "charout", lit2);
        eContext->SendMessage1(outp, "charout", command);
        eContext->SendMessage1(outp, "say", eContext->CString("]"));
    }
    return NULLOBJECT;      // sets RC to zero
}

RexxRoutineEntry add_envs_func[] = {

    REXX_TYPED_ROUTINE(add_envs , add_envs),
    REXX_LAST_ROUTINE()             // end marker
};


RexxPackageEntry Add_EnvsExternalRoutine_package_entry = {
    STANDARD_PACKAGE_HEADER
    REXX_INTERPRETER_5_0_0,         // ooRexx version 5.0.0 or higher
    "Add_EnvsExternalRoutine",      // name of the package
    "1.0.0",                        // package information
    NULL,                           // no load function
    NULL,                           // no unload function
    add_envs_func,                  // the exported routine
    NULL                            // the exported methods
};

// package loading stub.
OOREXX_GET_PACKAGE(Add_EnvsExternalRoutine);
