::routine xdate public
/* As the normal arg() functions would not do what one would expect, here are
    the corresponding functions for use in this routine.  The first column is
    the arg() function and the second is what to use in its place.
    arg()           n                       -- the number of arguments
    arg(i, E)       argArray~hasIndex(i)    -- was arg(i) passed
    arg(i, O)       \argArray~hasIndex(i)   -- was arg(i) omitted
    arg(i)          args[i]~strip(, '"')    -- the empty string if arg(i, O)
*/
    -- allow regular arguments as well as an argument array
    argArray = (arg(1)~isA(.array))~?(arg(1), arg(1, "A"))
    n = (argArray~items = 0)~?(0, argArray~last)    -- arg()
    args = .array~new   -- non-sparse array of arguments; omitted args are ""
    do j = 1 to n
        args[j] = (argArray~hasIndex(j))~?('"'argArray[j]'"', "")
    end
    argStr = args~makeString(, ", ")

    -- get first and third args (option and option2) and
    --  reduce to the only significant character in upper case
    opt = (n > 0)~?(args[1], "")[2]~upper
    opt2 = (n > 2)~?(args[3], "")[2]~upper
    select
        when opt = 'J' then do              -- to Julian date (yyddd)
            ans = xdate(argArray~~put("N", 1))~right(2)           -- get yy
            ans ||= xdate(argArray~~put("D", 1))~right(3, "0")    -- add ddd
        end
        when opt2 = 'J' then do             -- from Julian date (yyddd)
            ans = '???'
            -- check for valid date format
            jDate = args[2]~strip(, '"')
            if jDate~datatype("W"), jdate~length = 5 then do
                if .local~hasIndex("DATE.CC") then do
                    yr = .date.cc || jdate~left(2)
                    base = 'DATE'("B", yr"0101", "S") - 1 + (jDate~right(3))
                    ans = xdate(argArray~~put(base, 2)~~put("B", 3))
                end
                else do
                    say "Julian date" jdate "is ambiguous. Specify the first 2"
                    say "  digits of the year (cc) by setting .local[date.cc]."
                end
            end
            else
                say "Invalid Julian date; expected 'yyddd' but found ["jDate"]."
        end
        when opt = 'A' then do              -- to "American" date
                                            --  (e.g. June 8, 1975)
            monNames = "January", "February", "March", "April", "May", "June", -
                "July", "August", "September", "October", "November", "December"
            if .local~hasIndex("DATE.MONTHS") then  -- alt. month names
                monNames = .date.months
            parse value xdate(argArray~~put("S", 1)) with yr +4 mm +2 dd
            ans = monNames[mm] dd+0', 'yr   -- no leading zero on day
        end
        when opt2 = 'A' then do             -- from "American" date
            aDate = args[2]~strip(, '"')
            parse var aDate mon dayC yr
            nDate = dayC~strip('T', ',')~right(2, 0) mon~left(3) yr
            monAbbrev = "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug",-
                "Sep", "Oct", "Nov", "Dec"
            select
                when \yr~datatype("W") then
                    ? = .false
                when \monAbbrev~hasItem(nDate~Word(2)) then
                    ? = .false
                when \nDate~word(1)~datatype("W") then
                    ? = .false
                when \(nDate~word(1) > 0) then
                    ? = .false
                otherwise
                    ? = .true
            end
            if ? then
                ans = xdate(argArray~~put(nDate, 2)~~put('N', 3))
            else do
                ans = ???
                say "Invalid American date; expected 'Month dd, yyyy' but" -
                    "found ["aDate"]."
            end
        end
        otherwise
            /* show two ways to invoke the real BIF - first using 'interpret'
                and then by determining the correct combination of 'existing'
                and 'omitted' arguments; limit to cases of up to three arguments
                as each additional argument doubles the number of cases so for
                five arguments (like DATE) there are 32 cases.  */
            if n > 3 then
                interpret "ans = 'DATE'("argStr")"
            else do
                -- determine the number corresponding to the combination of
                --  arguments present; e.g. no args is 0, all three args is 7
                cs = 0          -- case number
                loop j = n to 1 by -1
                    cs *= 2
                    if argArray~hasIndex(j) then
                        cs += 1
                end
                select case cs
                    when 0 then
                        ans = 'DATE'()
                    when 1 then
                        ans = 'DATE'(a[1])
                    when 2 then
                        ans = 'DATE'(, a[2])
                    when 3 then
                        ans = 'DATE'(a[1], a[2])
                    when 4 then
                        ans = 'DATE'(, , a[3])
                    when 5 then
                        ans = 'DATE'(a[1], , a[3])
                    when 6 then
                        ans = 'DATE'(, a[2], a[3])
                    when 7 then
                        ans = 'DATE'(a[1], a[2], a[3])
                end
            end
    end
    return ans


::routine xwordpos public
/* As the normal arg() functions would not do what one would expect, here are
    the corresponding functions for use in this routine.  The first column is
    the arg() function and the second is what to use in its place.
    arg()           n                       -- the number of arguments
    arg(i, E)       argArray~hasIndex(i)    -- was arg(i) passed
    arg(i, O)       \argArray~hasIndex(i)   -- was arg(i) omitted
    arg(i)          args[i]~strip(, '"')    -- the empty string if arg(i, O)
*/
    -- allow regular arguments as well as an argument array
    argArray = (arg(1)~isA(.array))~?(arg(1), arg(1, "A"))
    n = (argArray~items = 0)~?(0, argArray~last)    -- arg()
    args = .array~new   -- non-sparse array of arguments; omitted args are ""
    do j = 1 to n
        args[j] = (argArray~hasIndex(j))~?('"'argArray[j]'"', "")
    end
    argStr = args~makeString(, ", ")

    if argArray~hasIndex(1) & argArray~hasIndex(2) then do  -- valid
        if \argArray~hasIndex(3) then
            argArray[3] = 1                     -- default start
        if \argArray~hasIndex(4) then
            argArray[4] = "C"                   -- default to Case sensitive
        ans = wordpos2(argArray[1], argArray[2], argArray[3], argArray[4])
    end
    else
        interpret "ans = wordpos2("argStr")"
    return ans

::requires rgf_util2.rex    -- needed for wordpos2
